--
--------------------------------------------------------------------------------
-- CHECKS  ---------------------------------------------------------------------
--

-- performs secpol checks for table art
CREATE OR REPLACE FUNCTION tsystem.secpol_check(IN row_data art, IN rec_old JSONB, IN rec_new JSONB, OUT check_ok BOOL, OUT hint VARCHAR) RETURNS RECORD
  AS $$
  BEGIN
    hint := prodat_languages.lang_text(34066)::VARCHAR; -- placeholder id, customer needs to actually set a meaningfull text for that id

    -- INSERT UPDATE DELETE
    check_ok :=
      (
        -- DELETE
        ( NOT(rec_new ? 'dbrid') AND ( (rec_old->>'ak_copy_exact')::bool IS NOT true ) ) -- /*new record null = DELETE
        OR
        -- INSERT UPDATE
        (    (rec_new ? 'dbrid') AND ( (rec_new->>'ak_copy_exact')::bool IS NOT true ) )
      )
    ;
  END $$ LANGUAGE plpgsql STABLE;

-- performs secpol checks for table opl
-- in this case only the parent of the record is relevant and thus called instead of its own check
CREATE OR REPLACE FUNCTION tsystem.secpol_check(IN row_data opl, IN rec_old JSONB, IN rec_new JSONB, OUT check_ok BOOL, OUT hint VARCHAR) RETURNS RECORD
  AS $$
  DECLARE
    _dbrid_old VARCHAR;
    _dbrid_new VARCHAR;

  BEGIN
    hint := null;

    -- INSERT UPDATE DELETE
    SELECT
      (SELECT dbrid FROM art WHERE ak_nr = rec_old->>'op_n'),
      (SELECT dbrid FROM art WHERE ak_nr = rec_new->>'op_n')
    INTO
      _dbrid_old,
      _dbrid_new
    ;

    SELECT
      (TSystem.secpol_check_exec_parent('art', _dbrid_old, _dbrid_new)).*
    INTO
      check_ok,
      hint
    ;

    -- placeholder id, customer needs to actually set a meaningfull text for that id
    hint := concat_ws(chr(10), hint, prodat_languages.lang_text(34069)::VARCHAR);
  END $$ LANGUAGE plpgsql STABLE;

-- performs secpol checks for table op2
-- in this case only the parent of the record is relevant and thus called instead of its own check
CREATE OR REPLACE FUNCTION tsystem.secpol_check(IN row_data op2, IN rec_old JSONB, IN rec_new JSONB, OUT check_ok BOOL, OUT hint VARCHAR) RETURNS RECORD
  AS $$
  DECLARE
    _dbrid_old VARCHAR;
    _dbrid_new VARCHAR;

  BEGIN
    hint := null;

    -- INSERT UPDATE DELETE
    SELECT
      (SELECT dbrid FROM opl WHERE op_ix = rec_old->>'o2_ix'),
      (SELECT dbrid FROM opl WHERE op_ix = rec_new->>'o2_ix')
    INTO
      _dbrid_old,
      _dbrid_new
    ;

    SELECT
      (TSystem.secpol_check_exec_parent('opl', _dbrid_old, _dbrid_new)).*
    INTO
      check_ok,
      hint
    ;

    -- placeholder id, customer needs to actually set a meaningfull text for that id
    hint := concat_ws(chr(10), hint, prodat_languages.lang_text(34070)::VARCHAR);
  END $$ LANGUAGE plpgsql STABLE;

-- performs secpol checks for table op6
-- in this case only the parent of the record is relevant and thus called instead of its own check
CREATE OR REPLACE FUNCTION tsystem.secpol_check(IN row_data op6, IN rec_old JSONB, IN rec_new JSONB, OUT check_ok BOOL, OUT hint VARCHAR) RETURNS RECORD
  AS $$
  DECLARE
    _dbrid_old VARCHAR;
    _dbrid_new VARCHAR;

  BEGIN
    hint := null;

    -- INSERT UPDATE DELETE
    SELECT
      (SELECT dbrid FROM opl WHERE op_ix = rec_old->>'o6_ix'),
      (SELECT dbrid FROM opl WHERE op_ix = rec_new->>'o6_ix')
    INTO
      _dbrid_old,
      _dbrid_new
    ;

    SELECT
      (TSystem.secpol_check_exec_parent('opl', _dbrid_old, _dbrid_new)).*
    INTO
      check_ok,
      hint
    ;

    -- placeholder id, customer needs to actually set a meaningfull text for that id
    hint := concat_ws(chr(10), hint, prodat_languages.lang_text(34071)::VARCHAR);
  END $$ LANGUAGE plpgsql STABLE;

-- performs secpol checks for table stv
-- in this case only the parent of the record is relevant and thus called instead of its own check
CREATE OR REPLACE FUNCTION tsystem.secpol_check(IN row_data stv, IN rec_old JSONB, IN rec_new JSONB, OUT check_ok BOOL, OUT hint VARCHAR) RETURNS RECORD
  AS $$
  DECLARE
    _dbrid_old VARCHAR;
    _dbrid_new VARCHAR;

  BEGIN
    hint := null;

    -- INSERT UPDATE DELETE
    SELECT
      (SELECT dbrid FROM art WHERE ak_nr = rec_old->>'st_zn'),
      (SELECT dbrid FROM art WHERE ak_nr = rec_new->>'st_zn')
    INTO
      _dbrid_old,
      _dbrid_new
    ;

    SELECT
      (TSystem.secpol_check_exec_parent('art', _dbrid_old, _dbrid_new)).*
    INTO
      check_ok,
      hint
    ;

    -- placeholder id, customer needs to actually set a meaningfull text for that id
    hint := concat_ws(chr(10), hint, prodat_languages.lang_text(34072)::VARCHAR);
  END $$ LANGUAGE plpgsql STABLE;

-- performs secpol checks for table epreis
-- in this case only the parent of the record is relevant and thus called instead of its own check
CREATE OR REPLACE FUNCTION tsystem.secpol_check(IN row_data epreis, IN rec_old JSONB, IN rec_new JSONB, OUT check_ok BOOL, OUT hint VARCHAR) RETURNS RECORD
  AS $$
  DECLARE
    _dbrid_old VARCHAR;
    _dbrid_new VARCHAR;

  BEGIN
    hint := null;

    -- INSERT UPDATE DELETE
    SELECT
      (SELECT dbrid FROM art WHERE ak_nr = rec_old->>'e_aknr'),
      (SELECT dbrid FROM art WHERE ak_nr = rec_new->>'e_aknr')
    INTO
      _dbrid_old,
      _dbrid_new
    ;

    SELECT
      (TSystem.secpol_check_exec_parent('art', _dbrid_old, _dbrid_new)).*
    INTO
      check_ok,
      hint
    ;

    -- placeholder id, customer needs to actually set a meaningfull text for that id
    hint := concat_ws(chr(10), hint, prodat_languages.lang_text(34073)::VARCHAR);
  END $$ LANGUAGE plpgsql STABLE;

-- performs secpol checks for table ab2
-- in this case only the parent(grandparent) of the record is relevant and thus called instead of its own check
CREATE OR REPLACE FUNCTION tsystem.secpol_check(IN row_data ab2, IN rec_old JSONB, IN rec_new JSONB, OUT check_ok BOOL, OUT hint VARCHAR) RETURNS RECORD
  AS  $$
  DECLARE
    _dbrid_old VARCHAR;
    _dbrid_new VARCHAR;

  BEGIN
    hint := null;

    -- INSERT UPDATE DELETE
    SELECT
      (SELECT art.dbrid FROM art LEFT JOIN abk ON abk.ab_ap_nr = art.ak_nr WHERE abk.ab_ix = rec_old->>'a2_ab_ix'),
      (SELECT art.dbrid FROM art LEFT JOIN abk ON abk.ab_ap_nr = art.ak_nr WHERE abk.ab_ix = rec_new->>'a2_ab_ix')
    INTO
      _dbrid_old,
      _dbrid_new
    ;

    SELECT
      (TSystem.secpol_check_exec_parent('art', _dbrid_old, _dbrid_new)).*
    INTO
      check_ok,
      hint
    ;

    -- placeholder id, customer needs to actually set a meaningfull text for that id
    hint := concat_ws(chr(10), hint, prodat_languages.lang_text(34074)::VARCHAR);
  END $$ LANGUAGE plpgsql STABLE;

-- performs secpol checks for table ab2_wkstplan
CREATE OR REPLACE FUNCTION tsystem.secpol_check(IN row_data ab2_wkstplan, IN rec_old JSONB, IN rec_new JSONB, OUT check_ok BOOL, OUT hint VARCHAR) RETURNS RECORD
  AS  $$
  DECLARE
    _dbrid_old VARCHAR;
    _dbrid_new VARCHAR;

  BEGIN
    hint := null;

    -- INSERT UPDATE DELETE
    SELECT
      (SELECT art.dbrid FROM ab2 JOIN abk ON a2_ab_ix = ab_ix JOIN art ON abk.ab_ap_nr = art.ak_nr WHERE ab2.a2_id = rec_old->>'a2w_a2_id'),
      (SELECT art.dbrid FROM ab2 JOIN abk ON a2_ab_ix = ab_ix JOIN art ON abk.ab_ap_nr = art.ak_nr WHERE ab2.a2_id = rec_new->>'a2w_a2_id')
    INTO
      _dbrid_old,
      _dbrid_new
    ;

    SELECT
      (TSystem.secpol_check_exec_parent('art', _dbrid_old, _dbrid_new)).*
    INTO
      check_ok,
      hint
    ;

    -- placeholder id, customer needs to actually set a meaningfull text for that id
    hint := concat_ws(chr(10), hint, prodat_languages.lang_text(34074)::VARCHAR);
  END $$ LANGUAGE plpgsql STABLE;

-- performs secpol checks for table auftg
-- in this case only the parent(grandparent) of the record is relevant and thus called instead of its own check
CREATE OR REPLACE FUNCTION tsystem.secpol_check(IN row_data auftg, IN rec_old JSONB, IN rec_new JSONB, OUT check_ok BOOL, OUT hint VARCHAR) RETURNS RECORD
  AS $$
  DECLARE
    _dbrid_old VARCHAR;
    _dbrid_new VARCHAR;

  BEGIN
    hint := null;

    -- INSERT UPDATE DELETE
    SELECT
      (SELECT art.dbrid FROM art LEFT JOIN abk ON abk.ab_ap_nr = art.ak_nr WHERE abk.ab_ix = rec_old->>'ag_parentabk'),
      (SELECT art.dbrid FROM art LEFT JOIN abk ON abk.ab_ap_nr = art.ak_nr WHERE abk.ab_ix = rec_new->>'ag_parentabk')
    INTO
      _dbrid_old,
      _dbrid_new
    ;

    SELECT
      (TSystem.secpol_check_exec_parent('art', _dbrid_old, _dbrid_new)).*
    INTO
      check_ok,
      hint
    ;

    -- placeholder id, customer needs to actually set a meaningfull text for that id
    hint := concat_ws(chr(10), hint, prodat_languages.lang_text(34075)::VARCHAR);
  END $$ LANGUAGE plpgsql STABLE;



--
--------------------------------------------------------------------------------
-- TRIGERS ---------------------------------------------------------------------
--

--
-- art ---
DROP TRIGGER IF EXISTS art__b_999_i__secpol_check ON art;
CREATE TRIGGER art__b_999_i__secpol_check
  BEFORE INSERT
  ON art
  FOR EACH ROW
  WHEN (tartikel.art__ak_copy_exact__is(new) )
  EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS art__b_999_u__secpol_check ON art;
  CREATE TRIGGER art__b_999_u__secpol_check
    BEFORE UPDATE
    ON art
    FOR EACH ROW
    WHEN (    (   TSystem.roles__user__group__is_in(current_user::varchar, 'SYS.QS-Art-Copy-Exact') IS false -- keine Berechtigung, dann Prüfung ausführen!
               OR tartikel.art__ak_copy_exact__is(new) -- Selbst mit Berechtigung muss zuerst/zugleich aktiv der Haken entfernt werden!
               )
          AND ( tartikel.art__ak_copy_exact__is(new) OR tartikel.art__ak_copy_exact__is(old) ) -- Artikel ist Copy Exact => FeldPrüfung
          AND ( tartikel.art__ak_copy_exact__is(old) IS true ) -- setzen darf ich immer => unabhängig der berechtigungen, rausnehmen nicht
          -- AND (TSystem.secpol_compare_records_oldnew(rec_old, rec_new, '{}', '{ak_copy_exact}')  -- only column 'ak_allgb2' differs
          )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS art__b_999_d__secpol_check ON art;
  CREATE TRIGGER art__b_999_d__secpol_check
    BEFORE DELETE
    ON art
    FOR EACH ROW
    WHEN (tartikel.art__ak_copy_exact__is(old) )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();



--
-- opl ---
DROP TRIGGER IF EXISTS opl__b_999_i__secpol_check ON opl;
CREATE TRIGGER opl__b_999_i__secpol_check
  BEFORE INSERT
  ON opl
  FOR EACH ROW
  WHEN (tartikel.art__ak_copy_exact__parent__is(new) )
  EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS op2__b_999_u__secpol_check ON opl;
  CREATE TRIGGER op2__b_999_u__secpol_check
    BEFORE UPDATE
    ON opl
    FOR EACH ROW
    WHEN (tartikel.art__ak_copy_exact__parent__is(new) OR tartikel.art__ak_copy_exact__parent__is(old) )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS op2__b_999_d__secpol_check ON opl;
  CREATE TRIGGER op2__b_999_d__secpol_check
    BEFORE DELETE
    ON opl
    FOR EACH ROW
    WHEN (tartikel.art__ak_copy_exact__parent__is(old) )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

--
-- op2 ---
DROP TRIGGER IF EXISTS op2__b_999_i__secpol_check ON op2;
CREATE TRIGGER op2__b_999_i__secpol_check
  BEFORE INSERT
  ON op2
  FOR EACH ROW
  WHEN (    (tartikel.art__ak_copy_exact__parent__is(new) )
        AND (tartikel.ks_copy_exact__is(new) ) -- Kostenstellen, welche ausdrücklich NICHT CE sind, darf ich einfügen!
          )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();


  DROP TRIGGER IF EXISTS op2__b_999_u__secpol_check ON op2;
  CREATE TRIGGER op2__b_999_u__secpol_check
    BEFORE UPDATE
    ON op2
    FOR EACH ROW
    WHEN (    (tartikel.art__ak_copy_exact__parent__is(new) OR tartikel.art__ak_copy_exact__parent__is(old) ) -- new/old, falls durch Kopieren, verschieben usw. AGs umgehangen werden (Planauftrag?)
          AND (tartikel.ks_copy_exact__is(new) OR tartikel.ks_copy_exact__is(old) )-- Kostenstellen, welche ausdrücklich NICHT CE sind, darf ich einfügen!)
          )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();


  DROP TRIGGER IF EXISTS op2__b_999_d__secpol_check ON op2;
  CREATE TRIGGER op2__b_999_d__secpol_check
    BEFORE DELETE
    ON op2
    FOR EACH ROW
    WHEN (    tartikel.art__ak_copy_exact__parent__is(old)
          AND tartikel.ks_copy_exact__is(old)
          )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

--
-- op6 ---
DROP TRIGGER IF EXISTS op6__b_999_i__secpol_check ON op6;
CREATE TRIGGER op6__b_999_i__secpol_check
  BEFORE INSERT
  ON op6
  FOR EACH ROW
  WHEN (tartikel.art__ak_copy_exact__parent__is(new))
  EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS op6__b_999_u__secpol_check ON op6;
  CREATE TRIGGER op6__b_999_u__secpol_check
    BEFORE UPDATE
    ON op6
    FOR EACH ROW
    WHEN (tartikel.art__ak_copy_exact__parent__is(new) OR tartikel.art__ak_copy_exact__parent__is(old) )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS op6__b_999_d__secpol_check ON op6;
  CREATE TRIGGER op6__b_999_d__secpol_check
    BEFORE DELETE
    ON op6
    FOR EACH ROW
    WHEN (tartikel.art__ak_copy_exact__parent__is(old) )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

--
-- stv ---
DROP TRIGGER IF EXISTS stv__b_999_i__secpol_check ON stv;
CREATE TRIGGER stv__b_999_i__secpol_check
  BEFORE INSERT
  ON stv
  FOR EACH ROW
  WHEN (tartikel.art__ak_copy_exact__parent__is(new) )
  EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS stv__b_999_u__secpol_check ON stv;
  CREATE TRIGGER stv__b_999_u__secpol_check
    BEFORE UPDATE
    ON stv
    FOR EACH ROW
    WHEN (tartikel.art__ak_copy_exact__parent__is(new) OR tartikel.art__ak_copy_exact__parent__is(old) )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS stv__b_999_d__secpol_check ON stv;
  CREATE TRIGGER stv__b_999_d__secpol_check
    BEFORE DELETE
    ON stv
    FOR EACH ROW
    WHEN (tartikel.art__ak_copy_exact__parent__is(old) )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

--
-- epreis ---
DROP TRIGGER IF EXISTS epreis__b_999_i__secpol_check ON epreis;
CREATE TRIGGER epreis__b_999_i__secpol_check
  BEFORE INSERT
  ON epreis
  FOR EACH ROW
  WHEN (    ( (new.e_lkn <> '#') )
        AND (tartikel.art__ak_copy_exact__is(new.e_aknr) )
        )
  EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS epreis__b_999_u__secpol_check ON epreis;
  CREATE TRIGGER epreis__b_999_iu__secpol_check
    BEFORE UPDATE
    ON epreis
    FOR EACH ROW
    WHEN (    ( (new.e_lkn <> '#') OR (old.e_lkn <> '#') )
          AND (tartikel.art__ak_copy_exact__is(new.e_aknr) OR tartikel.art__ak_copy_exact__is(old.e_aknr) )
          )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS epreis__b_999_d__secpol_check ON epreis;
  CREATE TRIGGER epreis__b_999_d__secpol_check
    BEFORE DELETE
    ON epreis
    FOR EACH ROW
    WHEN (    ( (old.e_lkn <> '#') )
          AND (tartikel.art__ak_copy_exact__is(old.e_aknr) )
          )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

--
-- ab2 ---
DROP TRIGGER IF EXISTS ab2__b_999_i__secpol_check ON ab2;
CREATE TRIGGER ab2__b_999_i__secpol_check
  BEFORE INSERT
  ON ab2
  FOR EACH ROW
  WHEN  (    ( tartikel.art__ak_copy_exact__parent__is(new) )
          AND (tartikel.ks_copy_exact__is(new) ) -- Kostenstellen, welche ausdrücklich NICHT CE sind, darf ich einfügen!
          AND (TSystem.execution_code__is_disabled__cascade_save('ak_copy_exactly__disabled') IS false)
          )
  EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS ab2__b_999_u__secpol_check ON ab2;
  CREATE TRIGGER ab2__b_999_u__secpol_check
    BEFORE UPDATE
    ON ab2
    FOR EACH ROW
    WHEN  (    ( tartikel.art__ak_copy_exact__parent__is(new) OR tartikel.art__ak_copy_exact__parent__is(old) )
           AND (tartikel.ks_copy_exact__is(new) OR tartikel.ks_copy_exact__is(old) )-- Kostenstellen, welche ausdrücklich NICHT CE sind, darf ich einfügen!)
           AND (TSystem.execution_code__is_disabled__cascade_save('ak_copy_exactly__disabled') IS false)
           )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS ab2__b_999_d__secpol_check ON ab2;
  CREATE TRIGGER ab2__b_999_d__secpol_check
    BEFORE DELETE
    ON ab2
    FOR EACH ROW
    WHEN  (    ( tartikel.art__ak_copy_exact__parent__is(old) )
           AND (tartikel.ks_copy_exact__is(old) )
           AND (TSystem.execution_code__is_disabled__cascade_save('ak_copy_exactly__disabled') IS false)
           )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

--
-- ab2_wkstplan: drag drop auf andere Resource in Plantafel verhindern!
DROP TRIGGER IF EXISTS ab2_wkstplan__b_999_u__a2w_oks__secpol_check__copy_exact ON ab2_wkstplan;
CREATE TRIGGER ab2_wkstplan__b_999_u__a2w_oks__secpol_check__copy_exact
  BEFORE UPDATE
  OF a2w_oks
  ON ab2_wkstplan
  FOR EACH ROW
  WHEN (tartikel.art__ak_copy_exact__parent__is(new))
  EXECUTE PROCEDURE TSystem.alltables__b_iud__secpol_check();

--
-- auftg ---
DROP TRIGGER IF EXISTS auftg__b_999_u__secpol_check ON auftg;
CREATE TRIGGER auftg__b_999_u__secpol_check
  BEFORE INSERT
  ON auftg
  FOR EACH ROW
  WHEN (    ( (new.ag_parentabk IS NOT NULL) )
        AND ( tartikel.art__ak_copy_exact__parent__is(new) )
        AND (TSystem.execution_code__is_disabled__cascade_save('ak_copy_exactly__disabled') IS false)
        )
  EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();


  DROP TRIGGER IF EXISTS auftg__b_999_u__secpol_check ON auftg;
  CREATE TRIGGER auftg__b_000_u__secpol_check
    BEFORE UPDATE
    ON auftg
    FOR EACH ROW
    WHEN (    ( (old.ag_parentabk IS NOT NULL) OR (new.ag_parentabk IS NOT NULL) )
          AND ( tartikel.art__ak_copy_exact__parent__is(new) OR tartikel.art__ak_copy_exact__parent__is(old) )
          AND (TSystem.execution_code__is_disabled__cascade_save('ak_copy_exactly__disabled') IS false)
          )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

  DROP TRIGGER IF EXISTS auftg__b_999_d__secpol_check ON auftg;
  CREATE TRIGGER auftg__b_999_d__secpol_check
    BEFORE DELETE
    ON auftg
    FOR EACH ROW
    WHEN (    ( (old.ag_parentabk IS NOT NULL) )
          AND ( tartikel.art__ak_copy_exact__parent__is(old) )
          AND (TSystem.execution_code__is_disabled__cascade_save('ak_copy_exactly__disabled') IS false)
          )
    EXECUTE FUNCTION TSystem.alltables__b_iud__secpol_check();

